import moment from 'moment-timezone';

import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';

import humanizeDuration from 'projects/trains/lib/date/duration/humanizeDuration';

import {getTrainsTransferDurationBySegments} from './getTrainsTransferDurationBySegments';

export const getTrainsTransferHumanDurationBySegments = ({
    currentSegment,
    nextSegment,
}: {
    currentSegment: ITrainsSegment;
    nextSegment: ITrainsSegment;
}): string => {
    const duration = getTrainsTransferDurationBySegments({
        currentSegment,
        nextSegment,
    });

    return humanizeDuration(moment.duration(duration, 'seconds'));
};
