import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';
import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {checkHasTrainsVariantTransfer} from 'projects/trains/lib/genericSearch/variants/checkHasTrainsVariantTransfer';
import {checkHasTrainsVariantTariffClasses} from 'projects/trains/lib/genericSearch/variants/checkHasTrainsVariantTariffClasses';
import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';

const checkHasTrainsSegmentNonRefundableTariff = (
    segment: ITrainsSegment,
): boolean => {
    const tariffClasses = segment.tariffs?.classes;

    if (!tariffClasses) {
        return false;
    }

    return Object.entries(tariffClasses).some((tariffClassAndType): boolean => {
        const [, tariffClass] = tariffClassAndType;

        return Boolean(tariffClass?.hasNonRefundableTariff);
    });
};

export const checkHasTrainsVariantNonRefundableTariff = (
    variantAndDirection: ITrainsVariantAndDirection,
): boolean => {
    const hasVariantTransfer =
        checkHasTrainsVariantTransfer(variantAndDirection);
    const hasTrainsVariantTariffClasses =
        checkHasTrainsVariantTariffClasses(variantAndDirection);

    if (!hasTrainsVariantTariffClasses || hasVariantTransfer) {
        return false;
    }

    const segments = getTrainsVariantSegments(variantAndDirection);

    return segments.some(segment =>
        checkHasTrainsSegmentNonRefundableTariff(segment),
    );
};
