import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';
import {checkHasTrainsSegmentTariffClasses} from 'projects/trains/lib/genericSearch/tariffs/checkHasTrainsSegmentTariffClasses';

export const checkHasTrainsVariantTariffClasses = (
    variantAndDirection: ITrainsVariantAndDirection,
): boolean => {
    const segments = getTrainsVariantSegments(variantAndDirection);

    return segments.every(segment =>
        checkHasTrainsSegmentTariffClasses(segment),
    );
};
