import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {EDirection} from 'types/common/EDirection';

import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';

export const checkHasTrainsVariantWithBackward = (
    variant: ITrainsVariant,
): boolean => {
    const segments = getTrainsVariantSegments({
        variant,
        direction: EDirection.BACKWARD,
    });

    return segments.length > 0;
};
