import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';
import {
    isFilledTrainsSearchContext,
    TrainsSearchContextType,
} from 'reducers/trains/context/types';

import {getTrainsVariantLocalDepartureTime} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantDeparture';
import getNextSearchDayMoment from 'projects/trains/lib/context/getNextSearchDayMoment';

export const checkIsNextDayDepartureVariant = ({
    context,
    variantAndDirection,
}: {
    context: TrainsSearchContextType;
    variantAndDirection: ITrainsVariantAndDirection;
}): boolean => {
    const variantLocalDepartureTime =
        getTrainsVariantLocalDepartureTime(variantAndDirection);

    if (!variantLocalDepartureTime || !isFilledTrainsSearchContext(context)) {
        return false;
    }

    return variantLocalDepartureTime.isAfter(getNextSearchDayMoment(context));
};
