import {ITrainsVariantsAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsVariantMinPrice} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantMinPrice';

export interface IWithAndWithoutOption {
    hasVariantWithoutPrice: boolean;
    hasVariantWithPrice: boolean;
}

const INITIAL_WITH_AND_WITHOUT_OPTION: IWithAndWithoutOption = {
    hasVariantWithPrice: false,
    hasVariantWithoutPrice: false,
};

export const checkTrainsVariantsWithAndWithoutPrice = (
    variantsAndDirection: ITrainsVariantsAndDirection,
): IWithAndWithoutOption => {
    const {variants, direction} = variantsAndDirection;

    return variants
        .map(variant => getTrainsVariantMinPrice({variant, direction}))
        .reduce<IWithAndWithoutOption>(
            (resultWithAndWithoutOption, variantMinPrice) => {
                if (variantMinPrice?.value) {
                    resultWithAndWithoutOption.hasVariantWithPrice = true;
                } else {
                    resultWithAndWithoutOption.hasVariantWithoutPrice = true;
                }

                return resultWithAndWithoutOption;
            },
            {...INITIAL_WITH_AND_WITHOUT_OPTION},
        );
};
