import {EDirection} from 'types/common/EDirection';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {ETrainsVariantUrlOwner} from 'types/trains/common/variant/ETrainsVariantUrlOwner';

import * as i18nBlock from 'i18n/trains-variant-action-text';

export const getTrainsVariantActionText = ({
    owner,
    context,
    isPinnedSegment,
    isVariantWithTransfer,
}: {
    owner: ETrainsVariantUrlOwner;
    isVariantWithTransfer: boolean;
    context: ITrainsFilledSearchContext;
    isPinnedSegment?: boolean;
}): string => {
    const {returnWhen, direction} = context;
    const isBackwardDirection = direction === EDirection.BACKWARD;

    if (owner === ETrainsVariantUrlOwner.UFS) {
        return i18nBlock.buyOnUfs();
    }

    if (isVariantWithTransfer) {
        return i18nBlock.selectPlaces();
    }

    if (returnWhen) {
        if (isPinnedSegment) {
            if (isBackwardDirection) {
                return i18nBlock.changeForwardSegment();
            }

            return i18nBlock.changeBackwardSegment();
        }

        if (isBackwardDirection) {
            return i18nBlock.selectBackwardVariant();
        }

        return i18nBlock.selectForwardVariant();
    }

    return i18nBlock.selectPlace();
};
