import {EDirection} from 'types/common/EDirection';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {TTrainsVariantUrl} from 'types/trains/common/variant/ITrainsVariantUrl';
import {ETrainsVariantUrlOwner} from 'types/trains/common/variant/ETrainsVariantUrlOwner';

import {trainsURLs} from 'projects/trains/lib/urls';
import {getTrainsVariantFirstSegment} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantFirstSegment';
import {prepareTrainsContextForSearchUrl} from 'projects/trains/lib/urls/getTrainsSearchUrl';

export const getTrainsVariantActionUrl = ({
    variant,
    context,
    orderUrl,
    isPinnedSegment,
}: {
    variant: ITrainsVariant;
    orderUrl: TTrainsVariantUrl;
    context: ITrainsFilledSearchContext;
    isPinnedSegment?: boolean;
}): string => {
    const {returnWhen, direction} = context;

    if (orderUrl.owner === ETrainsVariantUrlOwner.UFS) {
        return orderUrl.url;
    }

    if (returnWhen) {
        const variantFirstSegment = getTrainsVariantFirstSegment({variant});

        if (isPinnedSegment && direction === EDirection.BACKWARD) {
            return trainsURLs.getTrainsSearchUrl({
                context: prepareTrainsContextForSearchUrl(context),
                direction: EDirection.FORWARD,
            });
        }

        if (direction !== EDirection.BACKWARD && variantFirstSegment) {
            return trainsURLs.getTrainsSearchUrl({
                context: prepareTrainsContextForSearchUrl(context),
                forwardSegmentId: variantFirstSegment.id,
                direction: EDirection.BACKWARD,
            });
        }
    }

    return trainsURLs.getTrainsOrderUrlBySearchParams({
        variant,
        context,
    });
};
