import {Moment} from 'moment-timezone';

import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsSegmentLocalArrivalTime} from 'projects/trains/lib/genericSearch/segments/getTrainsSegmentLocalArrivalTime';

import {getTrainsVariantLastSegment} from './getTrainsVariantLastSegment';

export const getTrainsVariantArrival = (
    variantAndDirection: ITrainsVariantAndDirection,
): string | undefined => {
    const lastSegment = getTrainsVariantLastSegment(variantAndDirection);

    return lastSegment?.arrival;
};

export const getTrainsVariantLocalArrivalTime = (
    variantAndDirection: ITrainsVariantAndDirection,
): Moment | undefined => {
    const lastSegment = getTrainsVariantLastSegment(variantAndDirection);

    if (!lastSegment) {
        return;
    }

    return getTrainsSegmentLocalArrivalTime(lastSegment);
};
