import {Moment} from 'moment-timezone';

import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsSegmentLocalDepartureTime} from 'projects/trains/lib/genericSearch/segments/getTrainsSegmentLocalDepartureTime';

import {getTrainsVariantFirstSegment} from './getTrainsVariantFirstSegment';

export const getTrainsVariantDeparture = (
    variantAndDirection: ITrainsVariantAndDirection,
): string | undefined => {
    const firstSegment = getTrainsVariantFirstSegment(variantAndDirection);

    return firstSegment?.departure;
};

export const getTrainsVariantLocalDepartureTime = (
    variantAndDirection: ITrainsVariantAndDirection,
): Moment | undefined => {
    const firstSegment = getTrainsVariantFirstSegment(variantAndDirection);

    if (!firstSegment) {
        return;
    }

    return getTrainsSegmentLocalDepartureTime(firstSegment);
};

export const getTrainsVariantDepartureStationTimezone = (
    variantAndDirection: ITrainsVariantAndDirection,
): string | undefined => {
    const firstSegment = getTrainsVariantFirstSegment(variantAndDirection);

    if (!firstSegment) {
        return;
    }

    return firstSegment.stationFrom.timezone;
};
