import {ETimeOfDay} from 'utilities/dateUtils/types';
import {TrainsSearchContextType} from 'reducers/trains/context/types';
import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTimeOfDay} from 'utilities/dateUtils';
import {getTrainsVariantLocalDepartureTime} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantDeparture';

import {checkIsNextDayDepartureVariant} from './checkIsNextDayDepartureVariant';

export const getTrainsVariantLocalDepartureTimeOfDay = ({
    context,
    variantAndDirection,
}: {
    context: TrainsSearchContextType;
    variantAndDirection: ITrainsVariantAndDirection;
}): ETimeOfDay | null => {
    const variantLocalDepartureTime =
        getTrainsVariantLocalDepartureTime(variantAndDirection);

    if (!variantLocalDepartureTime) {
        return null;
    }

    const isNextDayDepartureVariant = checkIsNextDayDepartureVariant({
        context,
        variantAndDirection,
    });
    const variantLocalDepartureHour = variantLocalDepartureTime.hour();
    const departureTimeOfDay = getTimeOfDay(variantLocalDepartureHour);

    if (departureTimeOfDay === ETimeOfDay.NIGHT && isNextDayDepartureVariant) {
        return ETimeOfDay.EVENING;
    }

    return departureTimeOfDay;
};
