import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsTotalDurationBySegments} from 'projects/trains/lib/genericSearch/transfers/getTrainsTotalDurationBySegments';

import {getTrainsVariantFirstSegment} from './getTrainsVariantFirstSegment';
import {getTrainsVariantLastSegment} from './getTrainsVariantLastSegment';

export const getTrainsVariantDuration = (
    variantAndDirection: ITrainsVariantAndDirection,
): number | undefined => {
    const firstSegment = getTrainsVariantFirstSegment(variantAndDirection);
    const lastSegment = getTrainsVariantLastSegment(variantAndDirection);

    if (firstSegment && lastSegment) {
        return getTrainsTotalDurationBySegments({
            firstSegment,
            lastSegment,
        });
    }
};
