import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';

import {
    ITrainsSegmentHighSpeedTrainOptions,
    getTrainsSegmentHighSpeedTrain,
} from '../segments/getTrainsSegmentHighSpeedTrain';

export const getTrainsVariantHighSpeedTrains = (
    variantAndDirection: ITrainsVariantAndDirection,
): (ITrainsSegmentHighSpeedTrainOptions | undefined)[] => {
    const equalHighSpeedTrains = [];
    const segments = getTrainsVariantSegments(variantAndDirection);

    for (const segment of segments) {
        const segmentHighSpeedTrain = getTrainsSegmentHighSpeedTrain(segment);

        if (!segmentHighSpeedTrain) {
            return [];
        }

        if (equalHighSpeedTrains.length) {
            const [equalHighSpeedTrain] = equalHighSpeedTrains;

            if (segmentHighSpeedTrain.id !== equalHighSpeedTrain.id) {
                return [];
            }
        } else {
            equalHighSpeedTrains.push(segmentHighSpeedTrain);
        }
    }

    return equalHighSpeedTrains;
};
