import _intersection from 'lodash/intersection';

import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';
import {ETrainsCoachType} from 'types/trains/common/tariffs/ETrainsCoachType';

import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';

export const getTrainsVariantIntersectionCoachTypes = (
    variantAndDirection: ITrainsVariantAndDirection,
): ETrainsCoachType[] => {
    const segments = getTrainsVariantSegments(variantAndDirection);

    return _intersection(
        ...segments.map((segment): ETrainsCoachType[] => {
            const segmentClasses = segment.tariffs?.classes;

            if (!segmentClasses) {
                return [];
            }

            return Object.keys(segmentClasses) as ETrainsCoachType[];
        }),
    );
};
