import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import IPrice from 'utilities/currency/PriceInterface';
import {calculateTrainsTariffsTotalPrice} from 'projects/trains/lib/genericSearch/tariffs/calculateTrainsTariffsTotalPrice';
import {getTrainsMaxPriceTariffsByVariant} from 'projects/trains/lib/genericSearch/tariffs/getTrainsMaxPriceTariffsByVariant';

import {getTrainsVariantSegments} from './getTrainsVariantSegments';

export const getTrainsVariantMaxPrice = (
    variantAndDirection: ITrainsVariantAndDirection,
): IPrice | undefined => {
    const variantSegments = getTrainsVariantSegments(variantAndDirection);
    const variantMaxPriceTariffs =
        getTrainsMaxPriceTariffsByVariant(variantAndDirection);

    if (variantMaxPriceTariffs.length === variantSegments.length) {
        return calculateTrainsTariffsTotalPrice(variantMaxPriceTariffs);
    }
};
