import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsMinPriceTariffsByVariant} from 'projects/trains/lib/genericSearch/tariffs/getTrainsMinPriceTariffsByVariant';
import {calculateTrainsTariffsTotalPrice} from 'projects/trains/lib/genericSearch/tariffs/calculateTrainsTariffsTotalPrice';
import IPrice from 'utilities/currency/PriceInterface';

import {getTrainsVariantSegments} from './getTrainsVariantSegments';

export const getTrainsVariantMinPrice = (
    variantAndDirection: ITrainsVariantAndDirection,
): IPrice | undefined => {
    const variantSegments = getTrainsVariantSegments(variantAndDirection);
    const variantMinPriceTariffs =
        getTrainsMinPriceTariffsByVariant(variantAndDirection);

    if (variantMinPriceTariffs.length === variantSegments.length) {
        return calculateTrainsTariffsTotalPrice(variantMinPriceTariffs);
    }
};
