import _flatMap from 'lodash/flatMap';

import {ETrainsCoachType} from 'types/trains/common/tariffs/ETrainsCoachType';
import {ITrainsVariantsAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsVariantIntersectionCoachTypes} from './getTrainsVariantIntersectionCoachTypes';

export const getTrainsVariantsCoachTypes = (
    variantsAndDirection: ITrainsVariantsAndDirection,
): ETrainsCoachType[] => {
    const {variants, direction} = variantsAndDirection;

    const notUniqCoachTypes = _flatMap(variants, variant =>
        getTrainsVariantIntersectionCoachTypes({variant, direction}),
    );

    return [...new Set(notUniqCoachTypes)];
};
