import {ITrainsVariantsAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import IPrice from 'utilities/currency/PriceInterface';

import {getTrainsVariantMaxPrice} from './getTrainsVariantMaxPrice';

export const getTrainsVariantsMaxPrice = (
    variantsAndDirection: ITrainsVariantsAndDirection,
): IPrice | undefined => {
    const {variants, direction} = variantsAndDirection;

    if (!variants?.length) {
        return undefined;
    }

    return variants.reduce<IPrice | undefined>((currentMaxPrice, variant) => {
        const maxPrice = getTrainsVariantMaxPrice({variant, direction});

        if (!maxPrice) {
            return currentMaxPrice;
        }

        if (!currentMaxPrice) {
            return maxPrice;
        }

        if (maxPrice.value > currentMaxPrice.value) {
            return maxPrice;
        }

        return currentMaxPrice;
    }, undefined);
};
