import {ITrainsVariantsAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsVariantDuration} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantDuration';

export const getTrainsVariantsMinDuration = (
    variantsAndDirection: ITrainsVariantsAndDirection,
): number | undefined => {
    const {variants, direction} = variantsAndDirection;

    return variants.reduce<number | undefined>(
        (resultMinimalDuration, variant) => {
            const variantDuration = getTrainsVariantDuration({
                variant,
                direction,
            });

            if (!resultMinimalDuration) {
                return variantDuration;
            }

            if (!variantDuration) {
                return resultMinimalDuration;
            }

            if (variantDuration < resultMinimalDuration) {
                return variantDuration;
            }

            return resultMinimalDuration;
        },
        undefined,
    );
};
