import {ITrainsVariantsAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import IPrice from 'utilities/currency/PriceInterface';

import {getTrainsVariantMinPrice} from './getTrainsVariantMinPrice';

export const getTrainsVariantsMinPrice = (
    variantsAndDirection: ITrainsVariantsAndDirection,
): IPrice | undefined => {
    const {variants, direction} = variantsAndDirection;

    if (!variants?.length) {
        return undefined;
    }

    return variants.reduce<IPrice | undefined>((currentMinPrice, variant) => {
        const minPrice = getTrainsVariantMinPrice({variant, direction});

        if (!minPrice) {
            return currentMinPrice;
        }

        if (!currentMinPrice) {
            return minPrice;
        }

        if (minPrice.value < currentMinPrice.value) {
            return minPrice;
        }

        return currentMinPrice;
    }, undefined);
};
