import {
    ITrainsVariant,
    ITrainsVariantsAndDirection,
} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsVariantMinPrice} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantMinPrice';

export const getTrainsVariantsWithPrice = (
    variantsAndDirection: ITrainsVariantsAndDirection,
): ITrainsVariant[] => {
    const {variants, direction} = variantsAndDirection;

    return variants.filter(variant => {
        return Boolean(getTrainsVariantMinPrice({variant, direction}));
    });
};
