import {EDirection} from 'types/common/EDirection';
import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';
import {
    ITrainsVariant,
    ITrainsVariantAndDirection,
} from 'types/trains/common/variant/ITrainsVariant';

export const updateTrainsVariantSegments = ({
    segments,
    variantAndDirection,
}: {
    segments: ITrainsSegment[];
    variantAndDirection: ITrainsVariantAndDirection;
}): ITrainsVariant => {
    const {variant, direction} = variantAndDirection;

    if (direction === EDirection.BACKWARD) {
        return {
            ...variant,
            backward: segments,
        };
    }

    return {
        ...variant,
        forward: segments,
    };
};
