import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import * as i18nBlock from 'i18n/trains-coach-types';

export default function getCoachTypeText(type: TRAIN_COACH_TYPE): string {
    switch (type) {
        case TRAIN_COACH_TYPE.PLATZKARTE:
            return i18nBlock.platzkarte();
        case TRAIN_COACH_TYPE.COMPARTMENT:
            return i18nBlock.compartment();
        case TRAIN_COACH_TYPE.SUITE:
            return i18nBlock.suite();
        case TRAIN_COACH_TYPE.COMMON:
            return i18nBlock.common();
        case TRAIN_COACH_TYPE.SITTING:
            return i18nBlock.sitting();
        case TRAIN_COACH_TYPE.SOFT:
            return i18nBlock.soft();
    }
}
