import {GENDER_TYPE} from 'projects/trains/constants/genders';

import * as i18n from 'i18n/trains-transport-schema';

export default function getCompartmentGenderText(gender: GENDER_TYPE): string {
    switch (gender) {
        case GENDER_TYPE.MIXED:
            return i18n.coachDashMixedDashGenderDashGroup();
        case GENDER_TYPE.MALE:
            return i18n.coachDashMaleDashGenderDashGroup();
        case GENDER_TYPE.FEMALE:
            return i18n.coachDashFemaleDashGenderDashGroup();
        case GENDER_TYPE.SINGLE:
            return '';
    }
}
