import minBy from 'lodash/minBy';
import maxBy from 'lodash/maxBy';

import {makeCacheable} from 'projects/trains/lib/cache';
import IPrice from 'utilities/currency/PriceInterface';

/**
 * Метод вернет максимальную и минимальную цены из списка.
 * null значения будут проигнорированны
 */
function getExtremesWithoutCache(prices: IPrice[]): {
    min: IPrice | null;
    max: IPrice | null;
} {
    return {
        min: minBy(prices, 'value') || null,
        max: maxBy(prices, 'value') || null,
    };
}

export default makeCacheable(getExtremesWithoutCache);
