import ITrainRailwayStation from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainRailwayStation';
import {ITrainsStation} from 'types/trains/common/station/ITrainsStation';

import getFromToText, {
    IPointTextResult,
} from 'projects/trains/components/OrderSummary/containers/TrainItemContainer/utitlites/getFromToText';

interface IGetFromToByStationsParams {
    stationFrom: ITrainRailwayStation & ITrainsStation;
    stationTo: ITrainRailwayStation & ITrainsStation;
}

export default function getFromToByStations({
    stationFrom,
    stationTo,
}: IGetFromToByStationsParams): IPointTextResult {
    return getFromToText(
        {
            settlement: stationFrom.settlementTitle,
            station: stationFrom.popularTitle || stationFrom.title,
        },
        {
            settlement: stationTo.settlementTitle,
            station: stationTo.popularTitle || stationTo.title,
        },
    );
}
