import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import * as i18Block from 'i18n/trains-order-summary-details';

const mapTypeToTitle: Record<PASSENGERS_TYPES, string> = {
    [PASSENGERS_TYPES.ADULTS]: i18Block.itemDashTitleDashAdults(),
    [PASSENGERS_TYPES.CHILDREN]:
        i18Block.itemDashTitleDashChildrenDashRedesign(),
    [PASSENGERS_TYPES.BABIES]: i18Block.itemDashTitleDashBabiesDashRedesign(),
};

export default function getSummaryPassengerTypeText(
    passengersType: PASSENGERS_TYPES,
): string {
    return mapTypeToTitle[passengersType];
}
