import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import * as i18nBlock from 'i18n/trains-tariffs-classes';

export default function getTariffClass(
    tariffClass: TRAIN_COACH_TYPE,
    short = false,
): string {
    switch (tariffClass) {
        case TRAIN_COACH_TYPE.SUITE:
            return i18nBlock.suite();
        case TRAIN_COACH_TYPE.SOFT:
            return i18nBlock.soft();
        case TRAIN_COACH_TYPE.COMMON:
            return short ? i18nBlock.commonDashShort() : i18nBlock.common();
        case TRAIN_COACH_TYPE.COMPARTMENT:
            return i18nBlock.compartment();
        case TRAIN_COACH_TYPE.PLATZKARTE:
            return short
                ? i18nBlock.platzkarteDashShort()
                : i18nBlock.platzkarte();
        case TRAIN_COACH_TYPE.SITTING:
            return short ? i18nBlock.sittingDashShort() : i18nBlock.sitting();
    }
}
