import {EDirection} from 'types/common/EDirection';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

import {DateLikeType} from 'utilities/dateUtils';

export const getRouteDate = (
    context: ITrainsFilledSearchContext,
): DateLikeType => {
    const {when, returnWhen, direction} = context;

    if (direction === EDirection.BACKWARD && returnWhen) {
        return returnWhen;
    }

    return when;
};
