import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

import {humanFormatDate, getStartOfDay} from 'utilities/dateUtils';

import {getRouteDate} from '../getRouteDate/getRouteDate';

export const getRouteHumanFormatDate = (
    context: ITrainsFilledSearchContext,
): string => {
    const routeDate = getRouteDate(context);

    if (!routeDate) {
        return '';
    }

    const routeDay = getStartOfDay(routeDate);

    return humanFormatDate(routeDay).toLowerCase();
};
