import {EDirection} from 'types/common/EDirection';
import {
    ITrainsFilledContextPoints,
    ITrainsFilledSearchContext,
} from 'reducers/trains/context/types';

export const getRoutePoints = (
    context: ITrainsFilledSearchContext,
): ITrainsFilledContextPoints => {
    const {from, to, direction} = context;
    const isBackwardDirection = direction === EDirection.BACKWARD;

    return {
        from: isBackwardDirection ? to : from,
        to: isBackwardDirection ? from : to,
    };
};
