import {IFilledContextPoint} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';

import * as i18nBlock from 'i18n/trains-route-title';

// Функция возвращает заголовок направления откуда-куда в инфинитиве
export function getRouteTitleInfinitive({
    from,
    to,
}: {
    from: IFilledContextPoint;
    to: IFilledContextPoint;
}): string {
    return i18nBlock.titleDashInfinitive({
        fromTitle: from.title,
        toTitle: to.title,
    });
}
