import {IFilledContextPoint} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';

import * as i18nBlock from 'i18n/common-word-links';
import * as i18nTrainsRouteTitleBlock from 'i18n/trains-route-title';

// Функция возвращает заголовок направления откуда-куда c явным указанием откуда и куда
export function getRouteTitleInflected({
    from,
    to,
}: {
    from: IFilledContextPoint;
    to: IFilledContextPoint;
}): string {
    const params = {
        fromTitleGenitive: from.titleGenitive || '',
        toPreposition: to.preposition || i18nBlock._in(),
        toTitleAccusative: to.titleAccusative || '',
    };

    return i18nTrainsRouteTitleBlock.titleDashInflected(params);
}
