import {ITrainsFilledContextPoints} from 'reducers/trains/context/types';

import {getRouteTitleInfinitive} from 'projects/trains/lib/meta/getRouteTitle/getRouteTitleInfinitive';
import {getRouteTitleInflected} from 'projects/trains/lib/meta/getRouteTitle/getRouteTitleInflected';

// Функция вернет разные формы поисковых заголовков
export function getRouteTitle(points: ITrainsFilledContextPoints): {
    titleInfinitive: string;
    titleInflected: string;
} {
    return {
        titleInfinitive: getRouteTitleInfinitive(points),
        titleInflected: getRouteTitleInflected(points),
    };
}
