import {TLD} from 'constants/tld';

import {IMeta} from 'projects/trains/lib/meta/types';
import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';

import {IDevice} from 'reducers/common/commonReducerTypes';

import getSearchMetaDescription from 'projects/trains/lib/meta/searchMeta/getSearchMetaDescription';
import getSearchMetaTitle from 'projects/trains/lib/meta/searchMeta/getSearchMetaTitle';
import {getTrainsSearchCanonicalUrl} from 'projects/trains/lib/meta/searchMeta/getTrainsSearchCanonicalUrl';
import getGenericSemanticData from 'projects/trains/lib/meta/searchMeta/semanticData/getGenericSemanticData';

/*
 * Формирует метаинформацию для страницы поиска
 */
export default function getGenericSearchMeta({
    context,
    filters,
    sort,
    deviceType,
    tld,
}: {
    context: ITrainsFilledSearchContext;
    filters?: ITrainsFilters | null;
    sort: ITrainsSearchSort;
    deviceType: IDevice;
    tld: TLD;
}): IMeta {
    const metaTitle = getSearchMetaTitle({context});
    const description = getSearchMetaDescription(context);
    const canonicalUrl = getTrainsSearchCanonicalUrl({
        tld,
        sort,
        context,
        filters,
        deviceType,
    });
    const semanticData = getGenericSemanticData({
        tld,
        sort,
        context,
        filters,
        deviceType,
    });

    return {
        title: metaTitle,
        description,
        ogTitle: metaTitle,
        ogDescription: description,
        canonicalUrl,
        semanticData,
    };
}
