import moment from 'moment';

import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

import {humanList} from 'utilities/strings/humanList';
import {DateLikeType, getNow} from 'utilities/dateUtils';
import isAllDaysSearch from 'projects/trains/lib/search/isAllDaysSearch';
import {getRouteDate} from 'projects/trains/lib/meta/getRouteDate/getRouteDate';
import {getRoutePoints} from 'projects/trains/lib/meta/getRoutePoints/getRoutePoints';

import * as i18nBlock from 'i18n/trains-meta-search';

/*
 * Функция вернет список лет для отображения в мета описании в зависимости от текущего месяца.
 */
export function getYears(now: DateLikeType): number[] {
    const nowMoment = moment(now);
    const year = nowMoment.year();

    return nowMoment.month() < 10 ? [year] : [year, year + 1];
}

/*
 * Функция вернет год/года для отображения в мета описании.
 */
function getYear(context: ITrainsFilledSearchContext): number | string {
    const routeDate = getRouteDate(context);

    return isAllDaysSearch(context)
        ? humanList(getYears(getNow()))
        : moment(routeDate).year();
}

/*
 * Функция вернет поисковый meta description
 */
export default function getSearchMetaDescription(
    context: ITrainsFilledSearchContext,
): string {
    const {from, to} = getRoutePoints(context);

    return i18nBlock.descriptionDashTransportDashTrain({
        from: from.title,
        to: to.title,
        year: getYear(context),
    });
}
