import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

import {
    isTodaySearch,
    isTomorrowSearch,
} from 'projects/trains/lib/search/isNamedDaySearch';
import {getRouteTitle} from 'projects/trains/lib/meta/getRouteTitle';
import isAllDaysSearch from 'projects/trains/lib/search/isAllDaysSearch';
import {getRoutePoints} from 'projects/trains/lib/meta/getRoutePoints/getRoutePoints';
import {getRouteHumanFormatDate} from 'projects/trains/lib/meta/getRouteHumanFormatDate/getRouteHumanFormatDate';

import * as i18nBlockTrainsSearchWindowTitle from 'i18n/trains-search-window-title';
import * as i18nBlockTrainsMetaDefault from 'i18n/trains-meta-default';
import * as i18nBlockTrainsWhenSpecialValues from 'i18n/trains-whenSpecialValues';

/*
 * Вернет заголовок для meta title страницы поиска
 */
function getTitle({context}: {context: ITrainsFilledSearchContext}): string {
    const points = getRoutePoints(context);
    const route = getRouteTitle(points);

    return i18nBlockTrainsSearchWindowTitle.trainDashDate({
        routeTitleInfinitive: route.titleInfinitive,
    });
}

/*
 * Вернет подзаголовок для meta title страницы поиска
 */
function getSubtitle({context}: {context: ITrainsFilledSearchContext}): string {
    if (isAllDaysSearch(context)) {
        return '';
    }

    if (isTodaySearch(context)) {
        return i18nBlockTrainsWhenSpecialValues.today();
    }

    if (isTomorrowSearch(context)) {
        return i18nBlockTrainsWhenSpecialValues.tomorrow();
    }

    return getRouteHumanFormatDate(context);
}

/*
 * Вернет meta title для страницы поиска
 */
export default function getSearchMetaTitle({
    context,
}: {
    context: ITrainsFilledSearchContext;
}): string {
    const title = getTitle({context});
    const subtitle = getSubtitle({context});

    return i18nBlockTrainsMetaDefault.titleDashWithDashServiceDashName({
        title: subtitle ? `${title}, ${subtitle}` : title,
    });
}
