import {TLD} from 'constants/tld';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';
import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';

import {IDevice} from 'reducers/common/commonReducerTypes';

import isIOS11 from 'utilities/deviceType/isIOS11';
import getFiltersQuery from 'projects/trains/lib/filters/getFiltersQuery';
import getTrainsSortingQuery from 'projects/trains/lib/sort/getTrainsSortingQuery';
import {trainsURLs} from 'projects/trains/lib/urls';
import {getRoutePoints} from 'projects/trains/lib/meta/getRoutePoints/getRoutePoints';

/*
 * Возвращает каноническую ссылку для страницы поиска
 */
export function getTrainsSearchCanonicalUrl({
    context,
    filters,
    sort,
    deviceType,
    tld,
}: {
    context: ITrainsFilledSearchContext;
    filters?: ITrainsFilters | null;
    sort?: ITrainsSearchSort;
    deviceType: IDevice;
    tld?: TLD;
}): string {
    const {when} = context;
    const {from, to} = getRoutePoints(context);

    const params = isIOS11(deviceType.os)
        ? {
              context: {
                  from: from.slug,
                  to: to.slug,
                  when,
              },
              filters: getFiltersQuery(filters),
              sort: sort ? getTrainsSortingQuery(sort) : undefined,
          }
        : {
              context: {
                  from: from.slug,
                  to: to.slug,
                  when: WHEN_SPECIAL_VALUE.ALL_DAYS,
              },
          };

    return trainsURLs.getTrainsSearchUrl(params, {
        withOrigin: true,
        tld,
    });
}
