import {TLD} from 'constants/tld';

import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {getSemanticCrumbs} from 'projects/trains/lib/meta/searchMeta/semanticData/getSemanticCrumbs';

/*
 * Возвращает микроразметку с хлебными крошками
 */
export default function getSemanticData({
    context,
    filters,
    sort,
    tld,
}: {
    context: ITrainsFilledSearchContext;
    filters?: ITrainsFilters | null;
    sort: ITrainsSearchSort;
    deviceType: IDevice;
    tld: TLD;
}): string[] {
    const semanticCrumbs = JSON.stringify(
        getSemanticCrumbs({context, filters, sort, tld}),
    );

    return [semanticCrumbs];
}
