import {TLD} from 'constants/tld';

import {ISemanticCrumbs} from 'projects/trains/lib/meta/searchMeta/semanticData/types';
import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';

import getCrumbs from 'projects/trains/lib/meta/searchMeta/semanticData/getCrumbs';

/*
 * Возвращает структуру хлебных крошек в формате JSON-LD
 * https://yandex.ru/support/webmaster/json-ld/about.xml
 */
export function getSemanticCrumbs({
    context,
    filters,
    sort,
    tld,
}: {
    context: ITrainsFilledSearchContext;
    filters?: ITrainsFilters | null;
    sort: ITrainsSearchSort;
    tld: TLD;
}): ISemanticCrumbs {
    const crumbs = getCrumbs({
        context,
        filters,
        sort,
        urlOptions: {
            withOrigin: true,
            tld,
        },
    });

    return {
        '@context': 'http://schema.org',
        '@type': 'BreadcrumbList',
        itemListElement: crumbs.map(({url, name}, index) => ({
            '@type': 'ListItem',
            position: index + 1,
            item: {
                '@id': url,
                name,
            },
        })),
    };
}
