import {TLD} from 'constants/tld';
import {URLs} from 'constants/urls';

import {ICrumb} from 'projects/trains/lib/meta/searchMeta/semanticData/types';

import {internalUrl} from 'utilities/url';

import * as i18nBlock from 'i18n/trains-breadcrumbs';

/*
 * Возвращает хлебную крошку страницы поиска поездов
 */
export default function getTrainsPageCrumb(options?: {
    withOrigin: boolean;
    tld?: TLD;
}): ICrumb {
    return {
        url: internalUrl(URLs.trains, null, options),
        name: i18nBlock.mainDashPageDashNew(),
        title: i18nBlock.mainDashPageDashTitle(),
    };
}
