export interface ICrumb {
    url: string;
    name: string;
    title?: string;
}

interface ISemanticCrumbsItemListElement {
    '@type': string;
    position: number;
    item: {
        '@id': string;
        name: string;
    };
}

export interface ISemanticCrumbs {
    '@context': string;
    '@type': string;
    itemListElement: ISemanticCrumbsItemListElement[];
}

export function isNotNullableCrumbs(
    crumbs: (ICrumb | null)[],
): crumbs is ICrumb[] {
    return crumbs.indexOf(null) === -1;
}
