import {
    ICommerceProduct,
    ECommerceCategories,
} from 'utilities/metrika/types/ecommerce';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

import {CHAR_EM_DASH} from 'utilities/strings/charCodes';

/**
 * Данные о товаре для Электронной коммерции в Метрике.
 *
 * @see https://yandex.ru/support/metrika/data/e-commerce.html#e-commerce__product_data
 *
 * @param {ITrainsFilledSearchContext} context - Поисковый контекст.
 *
 * @return {ICommerceProduct}
 */
export default function getECommerceProductFromContext(
    context: ITrainsFilledSearchContext,
): ICommerceProduct {
    const {from, to} = context;

    return {
        id: `${from.key}-${to.key}`,
        name: `ЖД-билеты ${from.title} ${CHAR_EM_DASH} ${to.title}`,
        category: `${ECommerceCategories.TRAINS}/${from.title}/${to.title}`,
    };
}
