import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';

const PARTNER_FEE_AMOUNT = 30;
const RETURN_RATE = 0.015;

/**
 * Информация о полученном доходе для Электронной коммерции в Метрике.
 *
 * @see https://yandex.ru/support/metrika/data/e-commerce.html#e-commerce__action_data
 * @see https://st.yandex-team.ru/TRAINS-890#1541528675000
 *
 * @param {IGenericOrderInfo} orderInfo - Информация о заказе.
 *
 * @return {Number}
 */
export default function getECommerceRevenue(orderInfo: IGenericOrderInfo) {
    const revenue = getTrainServices(orderInfo).reduce((totalSum, service) => {
        return (
            totalSum +
            service.trainInfo.passengers.reduce((passengersSum, {ticket}) => {
                if (!ticket) {
                    return passengersSum;
                }

                return (
                    passengersSum +
                    ticket.payment.fee.value -
                    PARTNER_FEE_AMOUNT -
                    ticket.amount.value * RETURN_RATE
                );
            }, 0)
        );
    }, 0);

    return parseFloat(revenue.toFixed(2));
}
