import {mapSearchFilterToShowGoal} from 'projects/trains/constants/metrika';

import {
    ETrainsFilterType,
    ITrainsFilters,
} from 'types/trains/search/filters/ITrainsFilters';

import {reachGoal} from 'utilities/metrika';
import getEffectiveFilterManagers from 'projects/trains/lib/filters/getEffectiveFilterManagers';

const UNUSED_FILTERS_IN_DESKTOP: ETrainsFilterType[] = [];

const UNUSED_FILTERS_IN_MOBILE: ETrainsFilterType[] = [
    ETrainsFilterType.PRICE_RANGE,
];

/**
 * Отправляет события в метрику по применимости фильтров для выдачи
 *
 * @param filters - данные фильтрации
 * @param isMobile - мобильная версия сайта
 */
export default function reachFiltersGoal(
    filters: ITrainsFilters,
    isMobile: boolean,
) {
    const unusedFilters = isMobile
        ? UNUSED_FILTERS_IN_MOBILE
        : UNUSED_FILTERS_IN_DESKTOP;

    getEffectiveFilterManagers(filters)
        .filter(
            ({type}) =>
                filters[type].availableWithOptions &&
                !unusedFilters.includes(type),
        )
        .forEach(({type}) => reachGoal(mapSearchFilterToShowGoal[type]));
}
