import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {INearestTrainDatesByDirection} from 'types/trains/search/searchInfo/INearestTrainDates';
import {TrainsSearchContextType} from 'reducers/trains/context/types';

import {reachGoal} from 'utilities/metrika';
import {checkHasNearestTrainDatesByContext} from 'projects/trains/lib/genericSearch/nearestTrainDates/checkHasNearestTrainDatesByContext';

export const reachGoalNearestTrainDates = ({
    searchContext,
    nearestTrainDatesByDirection,
}: {
    searchContext: TrainsSearchContextType;
    nearestTrainDatesByDirection?: INearestTrainDatesByDirection;
}): void => {
    const hasNearestTrainDates = checkHasNearestTrainDatesByContext({
        searchContext,
        nearestTrainDatesByDirection,
    });

    if (hasNearestTrainDates) {
        reachGoal(ETrainsGoal.SEARCH_CAN_RENDER_NEAREST_TRAIN_DATES);
    }
};
