import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {ITrainsSearchBadgesInfo} from 'types/trains/search/badgesInfo/ITrainsSearchBadgesInfo';

import {reachGoal} from 'utilities/metrika';

export const reachGoalVariantNonRefundableBadges = (
    badgesInfo: ITrainsSearchBadgesInfo,
): void => {
    const hasNonRefundableTariff = Boolean(
        badgesInfo?.nonRefundableTariffVariantsInfo?.variantIds?.length,
    );

    if (hasNonRefundableTariff) {
        reachGoal(ETrainsGoal.SEARCH_PAGE_HAS_NON_REFUNDABLE_TARIFF);
    }
};
