import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';

import {reachGoal} from 'utilities/metrika';
import {checkHasTrainsVariantTransfer} from 'projects/trains/lib/genericSearch/variants/checkHasTrainsVariantTransfer';
import {checkHasTrainsVariantTariffClasses} from 'projects/trains/lib/genericSearch/variants/checkHasTrainsVariantTariffClasses';

export const reachGoalVariantWithoutTariffClasses = (
    variants: ITrainsVariant[],
): void => {
    variants.some(variant => {
        const hasVariantTransfer = checkHasTrainsVariantTransfer({variant});

        if (hasVariantTransfer) {
            const hasTrainsVariantTariffClasses =
                checkHasTrainsVariantTariffClasses({variant});

            if (!hasTrainsVariantTariffClasses) {
                reachGoal(ETrainsGoal.SEARCH_TRANSFERS_WITHOUT_PRICE);

                return true;
            }
        }

        return false;
    });
};
