import {ITrainsCoach} from 'reducers/trains/order/types';

/**
 * Вернёт признак того, что среди вагонов все беспересадочные и у них одинаковое время прибытия
 *
 *  @param coaches - вагоны
 */
export default function areAllCoachesThroughAndWithSameArrivalTime(
    coaches: ITrainsCoach[],
): boolean {
    if (coaches.some(coach => !coach.throughArrival)) {
        return false;
    }

    const arrivalTimes = new Set(coaches.map(coach => coach.throughArrival));

    return arrivalTimes.size === 1;
}
