import {ITrainsCoach} from 'reducers/trains/order/types';

import {makeCacheable} from 'projects/trains/lib/cache';

/**
 * Функция проверяет, у всех ли вагонов есть схема
 *
 * @param coaches - вагоны
 */
function areAllCoachesWithSchemas(coaches: ITrainsCoach[]): boolean {
    return coaches.every(({schemaId}) => schemaId);
}

export default makeCacheable(areAllCoachesWithSchemas);
